'use strict';
const fs = require('fs');
const path = require('path');
const axios = require('axios');

/**
 * Save artwork under /data/local-ai-playlists
 */
const OUT_DIR = '/data/local-ai-playlists';

async function generate(cfg, userPrompt, logger) {
  try {
    if (!fs.existsSync(OUT_DIR)) fs.mkdirSync(OUT_DIR, { recursive: true });

    let width = 1024, height = 1024;
    if (cfg.size && typeof cfg.size === 'string' && cfg.size.includes('x')) {
      const [w, h] = cfg.size.split('x').map(Number);
      if (w && h) { width = w; height = h; }
    }

    const url = cfg.baseUrl.replace(/\/$/, '') + '/sdapi/v1/txt2img';
    const res = await axios.post(url, {
      prompt: `Minimal high-contrast cover art representing: ${userPrompt}`,
      steps: 20, width, height, cfg_scale: 5
    }, { timeout: 120000 });

    const b64 = res?.data?.images?.[0];
    if (!b64) throw new Error('Image generation failed: no image in response');

    const file = path.join(OUT_DIR, `ai-cover-${Date.now()}.png`);
    fs.writeFileSync(file, Buffer.from(b64, 'base64'));
    logger.info('[LocalAI] Artwork written: ' + file);
    return file;
  } catch (err) {
    logger.error('[LocalAI] Artwork error: ' + err.message);
    throw err;
  }
}

module.exports = { generate };
