# Local AI Playlists (Volumio 4)

Generate playlists from a natural-language prompt using your **local LLM** (Ollama or OpenAI-compatible server).
Optionally generate artwork via Automatic1111. Target: **Volumio 4 (Bookworm, Node 20+)**.

## Features
- Prompt → LLM plan (genres, seeds) → local library search → queue → play
- Works with **local library** (MPD)
- Optional playlist artwork via **Automatic1111** (txt2img)
- Adds a Browse source ("AI Playlist") for convenience

## Requirements
- Volumio 4 (Bookworm)
- Local LLM:
  - **Ollama**: `http://<host>:11434`
  - **OpenAI-compatible** (LM Studio, vLLM, OpenWebUI shim…): `/v1/chat/completions`
- Optional: Automatic1111 at `http://<host>:7860`

## Install
1. Copy this folder to your machine and zip it:
   ```bash
   cd local-ai-playlists
   zip -r ../local-ai-playlists.zip .
   ```
2. SSH into Volumio:
   ```bash
   ssh volumio@<volumio-ip>
   ```
3. Upload zip (scp/WinSCP), then install:
   ```bash
   volumio plugin install /home/volumio/local-ai-playlists.zip
   volumio plugin enable local-ai-playlists
   ```
4. Open **Settings → Plugins → Local AI Playlists**:
   - Set **LLM Mode** (Ollama or OpenAI-compatible)
   - Set **Base URL** and **Model**
   - (Optional) Enable **Artwork** and set Image API URL

## Usage
- Go to **Plugins → Local AI Playlists → Create Playlist**.
- Enter a prompt (e.g. *“late-night downtempo with female vocals, 90–110 bpm”*).
- Click **Generate**. The queue is replaced with AI-picked tracks and playback starts.

## Logs & Troubleshooting
- Watch logs:
  ```bash
  journalctl -fu volumio
  ```
- Ensure your library is indexed (MPD lists tracks).
- If no tracks: try more specific genres/artists you own.
- If artwork fails: check your Automatic1111 endpoint.

## Uninstall
```bash
volumio plugin disable local-ai-playlists
volumio plugin uninstall local-ai-playlists
```

## Notes
- This plugin uses Volumio **core commands** to manage the queue, keeping the state machine intact.
- Playlist “artwork” is saved under `/data/local-ai-playlists/` for your reference.
